# バッチ設計書 15-npm run make-screenshot

## 概要

本ドキュメントは、three.jsプロジェクトにおけるE2Eテスト用参照スクリーンショット生成バッチ `npm run make-screenshot` の設計仕様を定義する。

### 本バッチの処理概要

Puppeteerを使用してexamplesディレクトリ配下のHTMLサンプルをレンダリングし、E2Eテスト用の参照スクリーンショット画像を生成・保存するバッチである。test-e2eバッチの`--make`オプション付き実行と同等の処理を行う。

**業務上の目的・背景**：E2Eテスト（test-e2e）は既存のスクリーンショットと現在のレンダリング結果を比較することで動作する。新規exampleを追加した場合や、既存exampleの描画内容を意図的に変更した場合は、新しい参照スクリーンショットを生成する必要がある。このバッチは、そのような参照画像の生成を自動化する。

**バッチの実行タイミング**：開発者によるローカル環境での手動実行。新規exampleの追加時、既存exampleの描画変更時、E2Eテスト失敗時の参照画像更新時に使用。

**主要な処理内容**：
1. ローカルHTTPサーバーの起動（ポート1234）
2. Puppeteerによるヘッドレスブラウザの起動（SwiftShader使用）
3. 指定されたexample（または全examples）のページ読み込み
4. 決定論的環境でのレンダリング待機
5. スクリーンショット撮影とexamples/screenshots/への保存

**前後の処理との関連**：`npm run build-module`によるビルド完了後に実行。生成されたスクリーンショットは`npm run test-e2e`の参照画像として使用される。

**影響範囲**：examples/screenshots/配下のJPEGファイル。

## バッチ種別

ユーティリティ / テスト準備 / スクリーンショット生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 不定 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 24以上がインストールされていること |
| 依存パッケージ | `npm ci`による依存関係のインストール完了 |
| ビルド完了 | `npm run build-module`によるthree.jsビルドファイルの生成完了 |
| examplesディレクトリ | examples/ディレクトリが存在すること |

### 実行可否判定

- build/ディレクトリにthree.core.js、three.module.js、three.webgpu.jsが存在すること
- examples/ディレクトリにHTMLファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --webgpu | フラグ | No | false | WebGPU関連のexamplesのみを対象とする |
| [examples] | 文字列リスト | No | 全examples | 特定のexampleのみを対象とする（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| examples/*.html | HTMLファイル | スクリーンショット対象のサンプルページ |
| build/three.*.js | JavaScriptファイル | ビルド済みthree.jsライブラリ |
| test/e2e/deterministic-injection.js | JavaScriptファイル | 決定論的テスト用のスクリプト |
| test/e2e/clean-page.js | JavaScriptファイル | ページクリーンアップ用スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| examples/screenshots/{example名}.jpg | JPEGファイル | 生成された参照スクリーンショット |
| stdout | テキスト | 生成結果のコンソール出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {example名}.jpg |
| 出力先 | examples/screenshots/ |
| 文字コード | バイナリ（JPEG） |
| 画像サイズ | 400x250ピクセル |
| 画像品質 | 95%（jpgQuality = 95） |

## 処理フロー

### 処理シーケンス

```
1. サーバー起動
   └─ utils/server.jsを使用してポート1234でHTTPサーバーを起動

2. ブラウザ起動
   └─ Puppeteerでヘッドレスブラウザを起動（SwiftShaderを使用）
   └─ ビューポート: 800x500（viewScale=2）

3. exampleファイル一覧取得
   └─ examples/ディレクトリからHTMLファイルを列挙
   └─ コマンドライン引数で指定されたexamplesに絞り込み

4. 各exampleに対するスクリーンショット生成
   └─ ページ読み込み → レンダリング待機 → スクリーンショット撮影 → 保存

5. 結果出力
   └─ 生成結果のサマリーをコンソール出力

6. クリーンアップ
   └─ ブラウザとサーバーを終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[HTTPサーバー起動]
    B --> C[Puppeteerブラウザ起動]
    C --> D[examplesファイル一覧取得]
    D --> E{引数でexample指定?}
    E -->|Yes| F[指定されたexamplesに絞り込み]
    E -->|No| G[例外リスト除外]
    F --> H{--webgpuフラグ?}
    G --> H
    H -->|Yes| I[webgpu_プレフィックスでフィルタリング]
    H -->|No| J[全examplesを対象]
    I --> K[各exampleをループ]
    J --> K
    K --> L[ページ読み込み]
    L --> M[決定論的スクリプト注入]
    M --> N[レンダリング待機]
    N --> O[スクリーンショット撮影]
    O --> P[1/2にスケールダウン]
    P --> Q[examples/screenshots/に保存]
    Q --> R[成功ログ出力]
    R --> S{次のexample?}
    S -->|Yes| K
    S -->|No| T[結果サマリー出力]
    T --> U[ブラウザ・サーバー終了]
    U --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークタイムアウト | ページ読み込みが5分を超過 | 例外リストに追加、または個別に再試行 |
| - | レンダータイムアウト | レンダリングが5秒を超過 | 例外リストに追加検討 |
| - | ファイル書き込みエラー | ディスク容量不足等 | ディスク空き容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 2回（numAttempts = 2） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | 全エラー |

### 障害時対応

1. 失敗したexample一覧がコンソールに出力される
2. 該当exampleを個別に指定して再実行
3. 繰り返し失敗する場合は例外リストへの追加を検討

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜全examples（約300-400件） |
| 目標処理時間 | example数に依存（1件あたり数秒〜数十秒） |
| メモリ使用量上限 | ブラウザ依存 |

## 排他制御

- 同一環境での同時実行は非推奨（ポート競合の可能性）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サーバー起動時 | （暗黙的） |
| 進捗ログ | 各example生成完了時 | "Screenshot generated for file {example名}" |
| 終了ログ | バッチ終了時 | "X screenshots successfully generated." |
| エラーログ | 生成失敗時 | エラー詳細（赤色出力） |
| 警告ログ | 未認識example指定時 | "Warning! Unrecognised example name: {example名}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗example数 | 1件以上 | コンソール出力 |

## 備考

- test-e2eの`--make`オプション付き実行と同等
- 撮影時は800x500ピクセルで撮影し、400x250に縮小して保存（viewScale=2）
- JPEG品質95%で保存
- 決定論的環境（Math.random、Date.now、performance.now固定）でレンダリング
- 新規exampleを追加した場合は、このバッチでスクリーンショットを生成後、test-e2e-covでカバレッジを確認
- GUIやStats.jsは自動的に非表示化される
